<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProcedureReportRequest;
use App\Http\Requests\ProcedureRequest;
use App\Http\Traits\Api_Trait;
use App\Models\Procedure;
use App\Models\Report;
use Illuminate\Http\Request;

class ProcedureReportController extends Controller
{
    use Api_Trait;
    public function index(Report $report)
    {
        $data = $report->procedures()->get();
        return $this->returnData($data, __('messages.procedure_list'));
    }

    public function store(ProcedureReportRequest $request, Report $report)
    {

        $report->procedures()->attach($request->procedure_id, [
            'notes' => $request->notes,
        ]);
        $report->update([
            'procedure_id' => $request->procedure_id
        ]);
        return $this->returnSuccessMessage(__('messages.procedure_attached'));
    }

    public function update(ProcedureReportRequest $request, Report $report, Procedure $procedure)
    {
        $report->procedures()->updateExistingPivot($procedure->id, [
            'notes' => $request->notes,
        ]);

        return $this->returnSuccessMessage(__('messages.procedure_updated'));
    }

    public function destroy(Report $report, Procedure $procedure)
    {
        $report->procedures()->detach($procedure->id);

        return $this->returnSuccessMessage(__('messages.procedure_detached'));
    }
}
