<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreReportRequest;
use App\Http\Resources\ReportResource;
use App\Http\Traits\Api_Trait;
use App\Models\Report;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class ReportController extends Controller
{
    use Api_Trait;
    public function getAllReports(Request $request)
    {
        $perPage = 10;
        $reports = Report::with(['type', 'status', 'procedures', 'user', 'attachments'])
            ->latest()
            ->paginate($perPage);

        return $this->paginatedResponse(ReportResource::collection($reports), $reports, __('messages.reports'));
    }
    public function index()
    {
        $reports = Report::with(['type', 'procedures', 'user', 'attachments'])
            ->where('user_id', auth()->id())
            ->latest()
            ->get();

        return $this->returnData(ReportResource::collection($reports), __('messages.reports'));
    }
    public function store(StoreReportRequest $request)
    {
        $report = Report::create([
            'user_id' => auth()->id(),
            'report_type_id' => $request->report_type_id,
            'description' => $request->description,
            'location' => $request->location,
            'll' => $request->ll,
            'lg' => $request->lg,
        ]);
        if (!empty($request->attachment_ids)) {
            $report->attachments()->attach($request->attachment_ids);
        }
        return $this->returnData($report, __('messages.report_created'));
    }

    public function show(Report $report)
    {
        $report->load(['type', 'procedures', 'user', 'attachments']);
        return $this->returnData( new ReportResource($report), __('messages.report_details'));
    }
}
