<?php

namespace App\Http\Controllers;

use App\Http\Requests\TeamRequest;
use App\Models\EmployeeTeam;
use App\Models\Team;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    public function index()
    {
        return response()->json(['types' => EmployeeTeam::select('id', 'name')->get()]);
    }
    public function store(TeamRequest $request)
    {
        $team = EmployeeTeam::create($request->all());
        return response()->json(['message' => __('messages.employee_team_created'), 'team' => $team]);
    }

    public function show(EmployeeTeam $employeeTeam)
    {
        return response()->json(['team' => $employeeTeam]);
    }

    public function update(TeamRequest $request, EmployeeTeam $employeeTeam)
    {
        $employeeTeam->update($request->all());

        return response()->json(['message' => __('messages.employee_team_updated'), 'type' => $employeeTeam]);
    }
}
