<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReportTypeRequest extends BaseFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function store()
    {
        return [
            'name'      => ['required', 'string', 'max:191', 'unique:report_types,name'],
            'notes'     => ['nullable', 'string', 'max:191'],
        ];
    }
    public function update()
    {
        return [
            'name'      => ['required', 'string', 'max:191', Rule::unique('report_types')->ignore($this->id, 'id')],
            'notes'     => ['nullable', 'string', 'max:191'],
        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->isMethod('POST')) {
            return $this->store();
        }
        if ($this->isMethod('PUT')) {
            return $this->update();
        }
    }
}
