<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ProcedureController;
use App\Http\Controllers\ProcedureReportController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReportTypeController;
use App\Models\Procedure;
use App\Models\ReportType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::get('/test', function () {
    return response()->json(['message' => 'API is working']);
});


Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/employees', [EmployeeController::class, 'index']); // Paginated
    Route::post('employees', [EmployeeController::class, 'store']);
    Route::get('employees/{employee}', [EmployeeController::class, 'show']);
    Route::put('employees/{employee}', [EmployeeController::class, 'update']);
    Route::delete('employees/{employee}', [EmployeeController::class, 'destroy']);

    // report Types
    Route::post('/report-types', [ReportTypeController::class, 'store']);
    Route::get('/report-types/{reportType}', [ReportTypeController::class, 'show']);
    Route::put('/report-types/{reportType}', [ReportTypeController::class, 'update']);
    Route::delete('/report-types/{reportType}', [ReportTypeController::class, 'destroy']);


    // Procedure API
    Route::get('/procedures', [ProcedureController::class, 'index']);
    Route::post('/procedures', [ProcedureController::class, 'store']);
    Route::get('/procedures/{procedure}', [ProcedureController::class, 'show']);
    Route::put('/procedures/{procedure}', [ProcedureController::class, 'update']);
    Route::delete('/procedures/{procedure}', [ProcedureController::class, 'destroy']);
});
