<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

# 🇪🇬 Nation Eye Backend (Laravel API)

This is the official backend for **Nation Eye**, a reporting system built with Laravel 10 and Sanctum. It supports OTP login, report submission with file uploads, and bilingual Arabic/English responses.

---

## 🚀 Features

- ✅ OTP login via phone and national ID
- ✅ Submit reports with location, type, and attachments
- ✅ File upload (images, audio, video, PDF)
- ✅ Multi-language support (Arabic + English)
- ✅ Token-based API authentication (Laravel Sanctum)
- ✅ Mobile SMS integration
- ✅ Validation messages in Arabic

---

## 🛠 Installation

- git clone https://github.com/bit-tech-sa/nation_eye_backend.git
- cd nation_eye_backend
- cp .env.example .env
- composer install
- php artisan key:generate
- php artisan migrate --seed
- php artisan storage:link
- php artisan serve

## API Endpoints
- Method	 Endpoint	     Description	            Auth
- POST	    /send-otp	    Send OTP code	             ❌
- POST	    /verify-otp	    Verify OTP & get token	     ❌
- GET	    /report-types	Get all report types	     ❌
- POST	    /reports	    Submit a new report	         ✅
- GET	    /reports	    List authenticated reports	 ✅
- GET	    /report/{id}	Get report by ID	         ✅



### Premium Partners

- **[Vehikl](https://vehikl.com/)**
- **[Tighten Co.](https://tighten.co)**
- **[WebReinvent](https://webreinvent.com/)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel/)**
- **[Cyber-Duck](https://cyber-duck.co.uk)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Jump24](https://jump24.co.uk)**
- **[Redberry](https://redberry.international/laravel/)**
- **[Active Logic](https://activelogic.com)**
- **[byte5](https://byte5.de)**
- **[OP.GG](https://op.gg)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
