<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminOrEmployee
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();

        // Check if authenticated user is an employee or admin
        if (
            $user instanceof \App\Models\Employee ||
            ($user->is_admin ?? false)
        ) {
            return $next($request);
        }

        return response()->json(['message' => 'غير مصرح لك'], 403);
    }
}
