<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Attachment extends Model
{
    use HasFactory;

    protected $fillable = [
        'file_path',
        'original_name',
        'mime_type'
    ];

    public function getFilePathAttribute($value)
    {
        // Return full URL instead of just stored path
        return $value ? Storage::disk('public')->url($value) : null;
    }
    public function reports()
    {
        return $this->belongsToMany(Report::class, 'attachment_report');
    }
}
