<?php

namespace Database\Seeders;

use App\Models\ReportType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class ReportTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types =
            [
                [
                    'name' => 'الإبلاغ عن جريمة',
                    'notes' => 'الإبلاغ عن جريمة',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'name' => 'مشكلة في الطريق',
                    'notes' => 'مشكلة في الطريق',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'name' => 'الاإبلاغ عن فساد',
                    'notes' => 'الاإبلاغ عن فساد',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
            ];

        Schema::disableForeignKeyConstraints();
        ReportType::truncate();
        Schema::enableForeignKeyConstraints();

        $chunked_types = array_chunk($types, 5);


        foreach ($chunked_types as $value) {
            ReportType::insert($value);
        }
    }
}
