<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProcedureController;
use App\Http\Controllers\ProcedureReportController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReportTypeController;
use App\Models\Procedure;
use App\Models\ReportType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware(['auth:sanctum', 'admin_or_employee'])->group(function () {
    // Assign Procedures to Report
    Route::get('/reports/{report}/procedures', [ProcedureReportController::class, 'index']);
    Route::post('report/{report}/procedures', [ProcedureReportController::class, 'store']);
    Route::put('report/{report}/procedures/{procedure}', [ProcedureReportController::class, 'update']);
    Route::delete('report/{report}/procedures/{procedure}', [ProcedureReportController::class, 'destroy']);
});
